#version 330
#extension GL_EXT_gpu_shader4 : enable
// space rainbowsMod01.fsh by tripzilch

//https://www.shadertoy.com/view/NsS3Rm
// Licence CC0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
uniform sampler2D iChannel3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract
#define TAU 6.283185307179586
#define phase3 vec3(0.0, 2.0943951023931953, 4.1887902047863905)
#define gamma vec3(2.2)
#define igamma vec3(0.454545)

vec3 florp(float a, float p) {
    // this one maps the color
    // a = brightness
    // p = mushrooms
    float b = clamp(2.*a - 1.,0.,1.); b *= b; b *= b; b *= b;
    vec3 res = pow(vec3(2.*a - a * a, a * a, b), gamma); // sRGB stands for stupid RGB
    vec3 f = (1. + sin(phase3 + p)) * 0.333333333;
    return res.bgr * f.x + res.rbg * f.y + res.rgb * f.z;
}

float onk(vec2 uv, float t) {
    // this one makes a wobbly function over t, ranged -1 .. 1
    float bx = uv.x * -3.13 + 2.04 * sin(uv.y * -2.3 + 1.3 * t) - 0.5* t;
    float by = uv.y * 4.17 - 1.73 * sin(uv.x * 2.5 - 0.7 * t) + 0.9 * t;
    return .5 * (sin(bx) + sin(by));
}

float unk(vec2 uv, float t) {
    // this one ALSO makes a wobbly function over t, ranged 0 .. 1
    float cx = uv.x * 2.23 - 3.33 * sin(uv.y * -1.3 + 0.3 * t) - 0.4* t;
    float cy = uv.y * -1.41 + 3.15 * sin(uv.x * 1.5 + 0.4 * t) + 0.1 * t;
    return .5 + .25 * (sin(cx) + sin(cy));
}

const vec3 H3 = vec3(0.5497004779019702, 0.671043606703789, 0.8191725133961644);
float space(vec2 uv, float t,float seed) {
    uv += vec2(271., 497.) * seed; // space is far--it's not
    uv.x += t * 15.;
    vec2 ij = floor(uv), fg = uv - ij - .5;
    float idx = 57. * ij.y + ij.x + seed + .5;
    vec3 cr = fract(777. * sin(555. * fract(idx * H3)));
    fg += (cr.xy - .5) * .8;
    fg *= 5.;
    return smoothstep(.5, .45, length(fg)) * step(.8, cr.z);
}

const vec2 cos_plz = vec2(0, 0.25); // actually forgot to multiply by TAU, but now it is what it is
void main (void)
//void mainImage(out vec4 fragColor, in vec2 fragCoord) 
{
    // Normalized pixel coordinates (from 0 to 1) (??)
    vec2 aspect = iResolution.xy / iResolution.y;
    vec2 uv = (gl_FragCoord.xy / iResolution.xy - 0.5) * aspect;
    uv *= 1.2; // scale
    float t = iTime * 0.2; // global speed
    vec2 ee = vec2(4.35, -5.33); // bonus numbers
    float c = unk(uv * vec2(0.43, -0.53), t); // weirdness amount
    vec2 trun = sin(cos_plz + c * 8. + t * 0.61); 
    vec2 wp = uv + trun;
    vec2 wq = uv - trun;
    float lava = 3. * onk(wp, t) * (1. + onk((wq + ee * c) * 0.618, t * .7)); // left as exercise for the reader
    float hi = 1.000420 + .7 * c; // how high we are 
    float a = smoothstep(-1., hi, lava); // brightness
    float hole = smoothstep(hi + .02, hi, lava); // no more brightness
    hole = max(0., hole - .4 * smoothstep(0., -1., lava));

    float scifi = min(1., // four space, please
          space(uv*5., t, 81.) 
        + space(uv*10., t, 72.)
        + space(uv*15., t, 63.)
        + space(uv*20., t, 54.)
        );
    vec3 col = florp(a, c * 12. + 2.5 * t);
    col = mix(vec3(scifi), col, hole); // put everything together

    // Output to screen
    gl_FragColor = vec4(pow(col, vec3(igamma)),1.0);
}
